package gov.va.med.mhv.usermgmt.service.impl;

import java.util.Collection;
import java.util.List;

import gov.va.med.mhv.usermgmt.bizobj.PatientAssembler;
import gov.va.med.mhv.usermgmt.bizobj.TermsConditionsVerHistAssembler;
import gov.va.med.mhv.usermgmt.bizobj.TermsConditionsVerHistBO;
import gov.va.med.mhv.usermgmt.service.TermsConditionsVerHistCollectionServiceResponse;

import gov.va.med.mhv.usermgmt.service.TermsConditionsVerHistService;

/**
 * Service implementation class for the TermsConditionsVerHist service
 * @see gov.va.med.mhv.usermgmt.service.TermsConditionsVerHistService
 */
public class TermsConditionsVerHistServiceImpl implements TermsConditionsVerHistService {

	/**
	 * Execute the GetAllTermsConditionsVerHist service
	 * @see gov.va.med.mhv.usermgmt.service.TermsConditionsVerHistService#GetAllTermsConditionsVerHist()
	 */
	public TermsConditionsVerHistCollectionServiceResponse getAllTermsConditionsVerHist() {
		TermsConditionsVerHistCollectionServiceResponse response = new TermsConditionsVerHistCollectionServiceResponse();
		
		List versionHistoryBOs = TermsConditionsVerHistBO.getAllTermsConditionsVerHist();
		
		Collection verHistTO = TermsConditionsVerHistAssembler.getTermsConditionsVerHistCollection(versionHistoryBOs);
		
		if (verHistTO.size() > 0 )
			response.addTermsConditionsVerHists(verHistTO);
		
		return response;
	}

}